// Arquivo: navegacao.js
// Objetivo: Redirecionar para a página de formulário ao clicar no botão de ajuda.

// Espera o conteúdo da página carregar completamente antes de rodar o script

console.log("PASSO 1: Arquivo navegacao.js foi carregado!");

document.addEventListener('DOMContentLoaded', () => {

    // Procura pelo botão com o id 'botao-ajuda-discreto'
    const botaoAjuda = document.getElementById('botao-ajuda-discreto');

    // Verifica se o botão realmente existe na página atual
    if (botaoAjuda) {
        // Adiciona um "escutador" que espera por um clique no botão
        botaoAjuda.addEventListener('click', () => {
            // Quando o botão for clicado, redireciona o usuário para a página do formulário
            console.log("Botão de ajuda clicado. Redirecionando...");
            window.location.href = 'Formulario.html';
        });
    }

});